/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.core.internal.server.IServerLifecycleListener;
import org.sonarlint.eclipse.core.internal.server.Server;
import org.sonarlint.eclipse.core.internal.utils.StringUtils;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedGlobalConfiguration;

public class ServersManager {
    static final String PREF_SERVERS = "servers";
    private static final String INITIALIZED_ATTRIBUTE = "initialized";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String AUTH_ATTRIBUTE = "auth";
    private static final String URL_ATTRIBUTE = "url";
    private static final String USERNAME_ATTRIBUTE = "username";
    private static final String PASSWORD_ATTRIBUTE = "password";
    private static final byte EVENT_ADDED = 0;
    private static final byte EVENT_CHANGED = 1;
    private static final byte EVENT_REMOVED = 2;
    private static ServersManager instance = new ServersManager();
    private final Map<String, IServer> serversById = new LinkedHashMap<String, IServer>();
    private final List<IServerLifecycleListener> serverListeners = new ArrayList<IServerLifecycleListener>();
    private IResourceChangeListener resourceChangeListener;
    protected boolean ignorePreferenceChanges = false;
    private static boolean initialized;
    private static boolean initializing;

    private ServersManager() {
    }

    protected synchronized void init() {
        if (initialized || initializing) {
            return;
        }
        initializing = true;
        this.loadServersList();
        initialized = true;
    }

    public static ServersManager getInstance() {
        return instance;
    }

    public static void shutdown() {
        if (instance == null) {
            return;
        }
        instance.shutdownImpl();
    }

    protected void shutdownImpl() {
        if (!initialized) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null && this.resourceChangeListener != null) {
            workspace.removeResourceChangeListener(this.resourceChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServerLifecycleListener(IServerLifecycleListener listener) {
        List<IServerLifecycleListener> list = this.serverListeners;
        synchronized (list) {
            this.serverListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServerLifecycleListener(IServerLifecycleListener listener) {
        List<IServerLifecycleListener> list = this.serverListeners;
        synchronized (list) {
            this.serverListeners.remove(listener);
        }
    }

    private void fireServerEvent(IServer server, byte b) {
        if (this.serverListeners.isEmpty()) {
            return;
        }
        ArrayList<IServerLifecycleListener> clone = new ArrayList<IServerLifecycleListener>();
        clone.addAll(this.serverListeners);
        for (IServerLifecycleListener srl : clone) {
            if (b == 0) {
                srl.serverAdded(server);
                continue;
            }
            if (b == 1) {
                srl.serverChanged(server);
                continue;
            }
            srl.serverRemoved(server);
        }
    }

    private void saveServersList() {
        try {
            IEclipsePreferences rootNode = InstanceScope.INSTANCE.getNode("org.sonarlint.eclipse.core");
            rootNode.sync();
            Preferences serversNode = rootNode.node(PREF_SERVERS);
            serversNode.removeNode();
            serversNode = rootNode.node(PREF_SERVERS);
            serversNode.put(INITIALIZED_ATTRIBUTE, "true");
            for (IServer server : this.serversById.values()) {
                Preferences serverNode = serversNode.node(server.getId());
                serverNode.put(NAME_ATTRIBUTE, server.getName());
                serverNode.put(URL_ATTRIBUTE, server.getHost());
                serverNode.putBoolean(AUTH_ATTRIBUTE, server.hasAuth());
            }
            serversNode.flush();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Unable to save server list", e);
        }
    }

    protected void loadServersList() {
        try {
            IEclipsePreferences rootNode = InstanceScope.INSTANCE.getNode("org.sonarlint.eclipse.core");
            rootNode.sync();
            Preferences serversNode = rootNode.nodeExists(PREF_SERVERS) ? rootNode.node(PREF_SERVERS) : DefaultScope.INSTANCE.getNode("org.sonarlint.eclipse.core").node(PREF_SERVERS);
            String[] stringArray = serversNode.childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String serverId = stringArray[n2];
                Preferences serverNode = serversNode.node(serverId);
                boolean auth = serverNode.getBoolean(AUTH_ATTRIBUTE, false);
                String name = serverNode.get(NAME_ATTRIBUTE, "");
                String url = serverNode.get(URL_ATTRIBUTE, "");
                Server sonarServer = new Server(serverId, name, url, auth);
                this.serversById.put(serverId, sonarServer);
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Unable to load server list", e);
        }
    }

    public void addServer(IServer server, String username, String password) {
        if (!initialized) {
            this.init();
        }
        if (this.serversById.containsKey(server.getId())) {
            throw new IllegalStateException("There is already a server with id '" + server.getId() + "'");
        }
        this.serversById.put(server.getId(), server);
        this.saveServersList();
        if (server.hasAuth()) {
            ServersManager.storeCredentials(server, username, password);
        }
        this.fireServerEvent(server, (byte)0);
    }

    private static void storeCredentials(IServer server, String username, String password) {
        try {
            ISecurePreferences secureServersNode = SecurePreferencesFactory.getDefault().node("org.sonarlint.eclipse.core").node(PREF_SERVERS);
            ISecurePreferences secureServerNode = secureServersNode.node(server.getId());
            secureServerNode.put(USERNAME_ATTRIBUTE, username, true);
            secureServerNode.put(PASSWORD_ATTRIBUTE, password, true);
            secureServersNode.flush();
        }
        catch (IOException | StorageException e) {
            throw new IllegalStateException("Unable to save secure credentials", e);
        }
    }

    public void removeServer(IServer server) {
        if (!initialized) {
            this.init();
        }
        if (this.serversById.containsKey(server.getId())) {
            this.serversById.remove(server.getId());
            this.saveServersList();
            ISecurePreferences secureServersNode = SecurePreferencesFactory.getDefault().node("org.sonarlint.eclipse.core").node(PREF_SERVERS);
            secureServersNode.node(server.getId()).removeNode();
            this.fireServerEvent(server, (byte)2);
        }
    }

    public List<IServer> getServers() {
        if (!initialized) {
            this.init();
        }
        return this.getServersNoInit();
    }

    public List<IServer> getServersNoInit() {
        return Collections.unmodifiableList(new ArrayList<IServer>(this.serversById.values()));
    }

    public IServer getServer(String id) {
        if (id == null) {
            return null;
        }
        if (!initialized) {
            this.init();
        }
        return this.serversById.get(id);
    }

    public void updateServer(IServer server, String username, String password) {
        if (server == null) {
            return;
        }
        if (!initialized) {
            this.init();
        }
        if (!this.serversById.containsKey(server.getId())) {
            throw new IllegalStateException("There is no server with id '" + server.getId() + "'");
        }
        ((Server)this.serversById.get(server.getId())).stop();
        this.serversById.put(server.getId(), server);
        this.saveServersList();
        if (server.hasAuth()) {
            ServersManager.storeCredentials(server, username, password);
        }
        this.fireServerEvent(server, (byte)1);
    }

    public static String getUsername(IServer server) {
        return ServersManager.getFromSecure(server, USERNAME_ATTRIBUTE);
    }

    public static String getPassword(IServer server) {
        return ServersManager.getFromSecure(server, PASSWORD_ATTRIBUTE);
    }

    private static String getFromSecure(IServer server, String attribute) {
        ISecurePreferences secureServersNode;
        block3: {
            try {
                secureServersNode = SecurePreferencesFactory.getDefault().node("org.sonarlint.eclipse.core").node(PREF_SERVERS);
                if (secureServersNode.nodeExists(server.getId())) break block3;
                return null;
            }
            catch (StorageException e) {
                throw new IllegalStateException("Unable to read secure credentials", e);
            }
        }
        ISecurePreferences secureServerNode = secureServersNode.node(server.getId());
        return secureServerNode.get(attribute, null);
    }

    public String validate(String serverId, String serverUrl, boolean editExisting) {
        if (StringUtils.isBlank(serverUrl)) {
            return "Server url must be specified";
        }
        if (StringUtils.isBlank(serverId)) {
            return "Server id must be specified";
        }
        if (!editExisting && this.serversById.containsKey(serverId)) {
            return "Server id already exists";
        }
        try {
            ConnectedGlobalConfiguration.builder().setServerId(serverId).build();
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return null;
    }

    public IServer create(String id, String name, String url, String username, String password) {
        return new Server(id, name, url, StringUtils.isNotBlank(username) || StringUtils.isNotBlank(password));
    }
}

